//------------------------
// PARAMETERS

float4x4 gWorldViewProjMatrix
<
   string paramClass="intrinsic";
   string paramName="worldViewProj";
> = float4x4(1,0,0,0, 0,1,0,0, 0,0,1,0, 0,0,0,1);

float4x4 gWorldViewProjScreenMatrix
<
   string paramClass="intrinsic";
   string paramName="worldViewProjScreen";
> = float4x4(1,0,0,0, 0,1,0,0, 0,0,1,0, 0,0,0,1);

sampler waveNormalMap : register(s0);
sampler waveDistortionMap : register(s1);

// END PARAMETERS


//--------------------------------
// FUNCTION_VS WaveDistortion30VS

uniform mat4  gWorldViewProjMatrix;
uniform mat4  gWorldViewProjScreenMatrix;

varying vec2 WaveCoords;
varying vec3 WaveTangent;
varying float Factor;
#ifdef OVERLAP
varying vec4 ScreenPos;
#endif

void main()
{
	gl_Position = gl_Vertex * gWorldViewProjMatrix;
	WaveCoords = gl_MultiTexCoord0.st;
	WaveTangent = gl_Normal;
	Factor = gl_MultiTexCoord1.s;

#ifdef OVERLAP
	// Get screen space position of vertex
	ScreenPos = gl_Position * gWorldViewProjScreenMatrix;
#endif
}


//--------------------------------
// FUNCTION_PS WaveDistortion30PS

uniform sampler2D waveNormalMap;
#ifdef OVERLAP
uniform sampler2D waveDistortionMap;
#endif

varying vec2 WaveCoords;
varying vec3 WaveTangent;
varying float Factor;
#ifdef OVERLAP
varying vec4 ScreenPos;
#endif

void main()
{
	// Get wave normal vector (from normalmap) in tangent space
	vec3 NWaveTan = texture2D( waveNormalMap, WaveCoords ).rgb;
	NWaveTan = normalize( (NWaveTan * 2.0) - 1.0 );
   
	// Transform wave normal vector (from normalmap) into world space
	vec3 worldtangent = vec3( 1.0, 0.0, 0.0 );
	float cosTheta = dot( WaveTangent, worldtangent );
	float sinTheta = cross( WaveTangent, worldtangent ).y;
   
	vec3 NWaveWorld;
	NWaveWorld.x = NWaveTan.x * cosTheta + NWaveTan.y * -sinTheta;
	NWaveWorld.y = NWaveTan.x * sinTheta + NWaveTan.y * cosTheta;
	NWaveWorld.z = NWaveTan.z;

	// Ramp ends to avoid hard edges
	vec3 up = vec3( 0.0, 0.0, 1.0 );
	NWaveWorld = mix(up, NWaveWorld, Factor);
	NWaveWorld = normalize(NWaveWorld);

#ifdef OVERLAP
	// Get wave from distortion map
	vec2 screenPosXY = ScreenPos.xy / ScreenPos.z;
	vec3 NWaveDistortionWorld;
	NWaveDistortionWorld = texture2D( waveDistortionMap, screenPosXY ).rgb;
	NWaveDistortionWorld = normalize( (NWaveDistortionWorld * 2.0) - 1.0 );

	vec3 N;

	vec3 normal = NWaveDistortionWorld;
	vec3 tangent = vec3(1.0, 0.0, 0.0 );
	vec3 binormal = vec3( 0.0, normal.z, -normal.y );		// binormal = cross(normal, tangent);
	tangent = normal * (-normal.x) + vec3(1.0, 0.0, 0.0);	// tangent = cross(binormal, normal);

	N = ((tangent  * NWaveWorld.x + 
		binormal * NWaveWorld.y) / length(normal.yz) + 
		normal   * NWaveWorld.z);            
#else
	vec3 N = NWaveWorld;
#endif

	// Change range from (-1.0, 1.0) to (0.0, 1.0)
	N = (N + 1.0) / 2.0;
	  
	// Done!
	gl_FragColor = vec4( N, 1.0 );
}
